﻿namespace Hims.Api.Hubs
{
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.SignalR;

    /// <summary>
    /// The communication hub.
    /// </summary>
    public class CommunicationHub : Hub
    {
        /// <summary>
        /// The communication.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public async Task CommunicationGlobal(CommunicationMessage model)
        {
            await Clients.Others.SendAsync("CommunicationGlobal", model).ConfigureAwait(false);
        }

        /// <summary>
        /// The send to group.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public async Task CommunicationGroup(CommunicationMessageAlt model)
        {
            await Clients.OthersInGroup(model.GroupName).SendAsync("CommunicationGroup", model).ConfigureAwait(false);
        }

        /// <summary>
        /// The subscribe individual communication.
        /// </summary>
        /// <param name="groupName">
        /// The group name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public async Task SubscribeToGroup(string groupName)
        {
            await Groups.AddToGroupAsync(Context.ConnectionId, groupName).ConfigureAwait(false);
        }

        /// <summary>
        /// The unsubscribe individual communication.
        /// </summary>
        /// <param name="groupName">
        /// The group name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        public async Task UnsubscribeToGroup(string groupName)
        {
            await Groups.RemoveFromGroupAsync(Context.ConnectionId, groupName).ConfigureAwait(false);
        }
    }
}
